/*
 * Decompiled with CFR 0.152.
 */
package builder.resid.resid;

import builder.resid.resid.Spline;

final class OpAmp {
    private final double EPSILON = 1.0E-8;
    private double x;
    private final double Vddt;
    private final double vmin;
    private final double vmax;
    protected final Spline opamp;
    final double[] out = new double[2];

    protected OpAmp(double[][] opamp, int length, double Vddt) {
        this.Vddt = Vddt;
        this.vmin = opamp[0][0];
        this.vmax = opamp[length - 1][0];
        this.opamp = new Spline(opamp, length);
    }

    protected void reset() {
        this.x = this.vmin;
    }

    protected double solve(double n, double vi) {
        double ak = this.vmin;
        double bk = this.vmax;
        double a = n + 1.0;
        double b = this.Vddt;
        double b_vi = b - vi;
        double c = n * (b_vi * b_vi);
        while (true) {
            double xk = this.x;
            this.opamp.evaluate(this.x, this.out);
            double vo = this.out[0];
            double dvo = this.out[1];
            double b_vx = b - this.x;
            double b_vo = b - vo;
            double f = a * (b_vx * b_vx) - c - b_vo * b_vo;
            double df = 2.0 * (b_vo * dvo - a * b_vx);
            this.x -= f / df;
            if (Math.abs(this.x - xk) < 1.0E-8) {
                this.opamp.evaluate(this.x, this.out);
                return this.out[0];
            }
            if (f < 0.0) {
                bk = xk;
            } else {
                ak = xk;
            }
            if (!(this.x <= ak) && !(this.x >= bk)) continue;
            this.x = (ak + bk) * 0.5;
        }
    }
}

